<?php declare(strict_types = 1);

namespace EshopOrders\FrontModule\Model;

use Core\Model\Helpers\BaseService;
use EshopOrders\FrontModule\Model\Dao\Discount;
use EshopOrders\Model\Entities\OrderDiscount;
use EshopSales\FrontModule\Model\OrderSales;
use Nette\DI\Container;
use Nette\SmartObject;

/**
 * Class CartHelper
 * @package EshopOrders\FrontModule\Model
 */
class CartHelper extends BaseService
{
	use SmartObject;
	/**
	 * @var Carts
	 */
	protected $cartsService;
	/**
	 * @var Speditions
	 */
	protected $speditionsService;

	/** @var Container */
	protected $container;

	/** @var OrderSales|null */
	protected $orderSales;

	public function __construct(Carts $carts, Speditions $speditions, Container $container)
	{
		$this->cartsService      = $carts;
		$this->speditionsService = $speditions;
		$this->container = $container;
	}

	// --------------- Doprava zdarma ------------

	public function countFreeSpedition()
	{
		$freeSpeditionPrice = $remainingPrice = null;

		$firstFreeSpedition = $this->speditionsService->getFirstFreeSpedition();
		if ($firstFreeSpedition) {
			$freeSpeditionPrice = $firstFreeSpedition->getFreeFrom();

			$cart      = $this->cartsService->getCurrentCart();
			$cartPrice = $cart->getCartItemsPrice();

			if ($cartPrice > $freeSpeditionPrice) {
				$remainingPrice = 0;
			} else {
				$remainingPrice = $freeSpeditionPrice - $cartPrice;
			}
		}

		$cart = $this->cartsService->getCurrentCart();
		foreach ($cart->getCartItems() as $item) {
			if ($item->freeDelivery === true) {
				$freeSpeditionPrice = $item->price; //ne 0 -> to by znamenalo ze neni zdarma nikdy
				$remainingPrice     = 0;
				break;
			}
		}

		return ['minPrice' => $freeSpeditionPrice, 'remaining' => $remainingPrice];
	}

	// --------------- Slevove kody ------------

	public function countDiscountPrice()
	{
		$orderSales = $this->orderSales;

		if ($orderSales === null) {
			return 0;
		}

		$cart = $this->cartsService->getCurrentCart();
		$cartValue = $cart->getCartItemsPrice();
		$price = 0;

		foreach ($orderSales->getOrderSalesFromCart($cartValue) as $sale) {
			$code = $sale->isAutoSale() ? $sale::AUTO_SALE_ID : $sale->code;

			$discount = new Discount($code, $sale->getAmount(), $sale->getType());
			$price += $discount->calculateDiscount($cartValue);
		}

		return $price;
	}

	public function setOrderSales(OrderSales $orderSales): void
	{
		$this->orderSales = $orderSales;
	}

}

