<?php declare(strict_types=1);

namespace EshopOrders\Model\Entities\Invoice;

use Doctrine\ORM\Mapping as ORM;
use Kdyby\Doctrine\Entities\Attributes\Identifier;
use Kdyby\Doctrine\Entities\MagicAccessors;

/**
 * @ORM\Table("eshop_orders__invoice_address")
 * @ORM\Entity
 */
class Address
{
	use Identifier;
	use MagicAccessors;

	/**
	 * @var string|null
	 * @ORM\Column(type="string", nullable=true)
	 */
	public $street;

	/**
	 * @var string|null
	 * @ORM\Column(type="string", nullable=true)
	 */
	public $city;

	/**
	 * @var string|null
	 * @ORM\Column(type="string", nullable=true)
	 */
	public $postal;

	/**
	 * @var string|null
	 * @ORM\Column(type="string", nullable=true)
	 */
	public $country;

}