<?php declare(strict_types = 1);

namespace EshopOrders\Model\Entities;

use Doctrine\ORM\Mapping as ORM;
use Kdyby\Doctrine\Entities\Attributes\Identifier;
use Gedmo\Mapping\Annotation as Gedmo;

/**
 * @ORM\Table("eshop_orders__order_card_payment_token")
 * @ORM\Entity
 */
class OrderCardPaymentToken
{
	use Identifier;

	/**
	 * @var Order
	 * @ORM\ManyToOne(targetEntity="Order")
	 * @ORM\JoinColumn(name="order_id", referencedColumnName="id", onDelete="CASCADE")
	 */
	public $order;

	/**
	 * @var string
	 * @ORM\Column(name="note", type="string", length=255, nullable=true)
	 */
	public $note;

	/**
	 * @var \DateTime
	 * @Gedmo\Timestampable(on="create")
	 * @ORM\Column(name="created", type="datetime")
	 */
	private $created;

	/**
	 * @var OrderCardPaymentHistory[]
	 * @ORM\OneToMany(targetEntity="OrderCardPaymentHistory", mappedBy="token")
	 */
	protected $history;

	public function __construct(Order $order)
	{
		$this->order = $order;
	}

	public function getToken(string $type = 'id')
	{
		return $this->getId();
	}

	public function getCreated(): \DateTimeInterface { return $this->created; }

	public function getHistory() { return $this->history; }
}
