<?php


namespace EshopOrders\AdminModule\Components\Customer;

use Core\Model\UI\BaseControl;
use Core\Model\UI\Form\BaseForm;
use EshopOrders\AdminModule\Model\GroupsCustomers;
use EshopOrders\Model\Entities\GroupCustomers;
use Nette\Http\IResponse;
use Nette\Utils\ArrayHash;

class GroupCustomersForm extends BaseControl
{
	/** @var GroupCustomers */
	public $groupCustomers;

	/** @var GroupsCustomers */
	protected $groupsCustomersService;

	public function __construct(GroupsCustomers $groupsCustomers)
	{
		$this->groupsCustomersService = $groupsCustomers;
	}

	public function render()
	{
		$this->template->render($this->getTemplateFile());
	}

	protected function createComponentForm()
	{
		$form = $this->createForm();

		$form->addText('short', 'eshopOrders.groupCustomersForm.short')->setMaxLength(60);
		$form->addText('name', 'eshopOrders.groupCustomersForm.name')->setRequired()->setMaxLength(255);
		$form->addBool('isPublished', 'eshopOrders.groupCustomersForm.isPublished')->setDefaultValue(0);

		$form->addSaveCancelControl('saveControl');

		$form->onSuccess[] = [$this, 'formSuccess'];

		return $form;
	}

	public function formSuccess(BaseForm $form, ArrayHash $values)
	{
		try {
			$groupCustomers = $this->groupCustomers ?: new GroupCustomers($values->short, $values->name);

			$groupCustomers->short       = $values->short;
			$groupCustomers->name        = $values->name;
			$groupCustomers->isPublished = $values->isPublished;

			$this->em->persist($groupCustomers);
			$this->em->flush();
			$form->addCustomData('groupCustomersId', $groupCustomers->getId());
			$this->getPresenter()->flashMessageSuccess('eshopOrders.groupCustomersForm.groupCustomersSaved');
		} catch (\Exception $e) {
			$form->addError($e->getMessage());

			return false;
		}
	}

	public function setGroupCustomers($id)
	{
		$this->groupCustomers = $this->em->getRepository(GroupCustomers::class)->find($id);

		if ($this->groupCustomers) {
			$form = $this['form'];
			$form->setDefaults([
				'short'       => $this->groupCustomers->short,
				'name'        => $this->groupCustomers->name,
				'isPublished' => $this->groupCustomers->isPublished,
			]);
		} else
			$this->getPresenter()->error(null, IResponse::S404_NOT_FOUND);
	}
}
