<?php declare(strict_types = 1);

namespace EshopOrders\AdminModule\Components\Order;

use Core\Model\UI\BaseControl;
use Core\Model\UI\Form\BaseForm;
use Nette\Utils\ArrayHash;
use EshopOrders\Model\Entities\Order;
use EshopOrders\Model\Entities\OrderSpedition;
use EshopOrders\Model\Orders;
use EshopOrders\AdminModule\Model\Speditions;

class OrderSpeditionForm extends BaseControl
{
	/** @var int @persistent */
	public $orderSpeditionId;
	
	/** @var OrderSpedition */
	public $orderSpedition;
	
	/** @var Order */
	public $order;
	
	/** @var Orders */
	protected $ordersService;
	
	/** @var Speditions */
	protected $speditionsService;
	
	public function __construct(Orders $orders, Speditions $speditions)
	{
		$this->ordersService     = $orders;
		$this->speditionsService = $speditions;
	}

	public function render()
	{
		$this->template->render($this->getTemplateFile());
	}
	
	/*******************************************************************************************************************
	 * ======================== Components
	 */

	protected function createComponentForm()
	{
		$form = $this->createForm();
		
		$speditions = $this->speditionsService->getAll();
		$speditionList = [];
		foreach ($speditions as $spedition) {
			$speditionList[$spedition->getId()] = $spedition->getName() . ' (cena ' . $spedition->getPrice() . ' Kč)';
		}

		$form->addSelect('spedition', 'eshopOrders.default.spedition', $speditionList);
		$form->addInteger('price', 'eshopOrders.default.speditionPrice');

		$form->addSaveCancelControl();
		$form->onSuccess[] = [$this, 'formSuccess'];

		return $form;
	}

	public function formSuccess(BaseForm $form, ArrayHash $values)
	{
		try {
			$order = $this->order;
			$orderSpedition = $this->order->getSpedition();
			$newSpedition = $this->speditionsService->get($values->spedition);
			
			$orderSpedition->setPrice($values->price);
			if(!$orderSpedition->getSpedition() || $orderSpedition->getSpedition()->getId() != $newSpedition->getId()) {
				$orderSpedition->setName($newSpedition->getName());
				$orderSpedition->setSpedition($newSpedition);
			}
			$this->em->persist($orderSpedition)->flush();
			
			$this->getPresenter()->flashMessageSuccess('eshopOrders.orderSpeditionForm.edited');
			
		} catch (\Exception $e) {
			$form->addError($e->getMessage());
			$this->redrawControl('form');

			return false;
		}
	}
	
	public function setOrder($orderId)
	{
		$this->order   = $this->ordersService->get($orderId);
		$this->orderSpedition = $this->order->getSpedition();
		
		if ($this->orderSpedition) {
			$i = $this->orderSpedition;
			
			$defaults = ['price'    => $i->getPrice()];
			if($i->getSpedition()) { $defaults['spedition'] = $i->getSpedition()->getId(); }
			$this['form']->setDefaults($defaults);
		}
	}
}
