<?php declare(strict_types = 1);

namespace EshopOrders\AdminModule\Model;

use Core\Model\Helpers\BaseEntityService;
use EshopOrders\Model\Entities\Order;
use EshopOrders\Model\Entities\OrderStatus;
use EshopOrders\Model\Entities\Status;
use Users\Model\Http\UserStorage;
use EshopOrders\Model\Statuses as PublicStatuses;

/**
 * @method Status|object|null getReference($id)
 * @method Status[]|null getAll()
 * @method Status|null get($id)
 */
class Statuses extends BaseEntityService
{
	protected $entityClass = Status::class;

	protected $cForSelectOption;

	/** @var UserStorage */
	protected $userStorage;

	/** @var PublicStatuses */
	protected $publicStatuses;

	public function __construct(UserStorage $userStorage, PublicStatuses $statuses)
	{
		$this->userStorage    = $userStorage;
		$this->publicStatuses = $statuses;
	}

	public function changeStatus(array $ids, string $status): bool
	{
		return $this->publicStatuses->changeStatus($ids, $status);
	}

	public function getForSelectOption(): array
	{
		if ($this->cForSelectOption === null)
			$this->cForSelectOption = ($this->getEr()->findPairs([], 'name', ['position' => 'asc']) ?: []);

		return $this->cForSelectOption;
	}

	public function sendOrderStatusEmail(Order $order, OrderStatus $orderStatus): void
	{
		$this->publicStatuses->sendOrderStatusEmail($order, $orderStatus);
	}
}
