<?php declare(strict_types = 1);

namespace EshopOrders\AdminModule\Presenters;

use EshopOrders\AdminModule\Model\Event\InvoiceRegenerateEvent;
use EshopOrders\Model\Invoices;
use EshopOrders\Model\Pdf\IInvoicePdfBuilderFactory;
use Mpdf\MpdfException;
use Nette\Application\BadRequestException;

abstract class BasePresenter extends \Core\AdminModule\Presenters\BasePresenter
{
	/** @var Invoices @inject */
	public $invoices;

	/** @var IInvoicePdfBuilderFactory @inject */
	public $invoicePdfBuilderFactory;

	public function checkRequirements($element)
	{
		parent::checkRequirements($element);
		if (!$this->getUser()->isAllowed($this->getFullModuleName(), 'access'))
			$this->error();
	}

	/**
	 * @param mixed $id
	 * @throws BadRequestException
	 * @throws MpdfException
	 */
	public function handlePdf($id): void
	{
		$invoice = $this->invoices->get((int) $id);

		if ($invoice === null) {
			$this->error();
		}

		$this->invoicePdfBuilderFactory->create($invoice)->render();
	}

	/**
	 * @param mixed $invoiceId
	 */
	public function handleRegenerateInvoice($invoiceId): void
	{
		if ($this->invoices->regenerateInvoice((int) $invoiceId)) {
			$this->presenter->flashMessageSuccess('eshopOrders.invoicesGrid.actions.regenerateSuccess');
		} else {
			$this->presenter->flashMessageDanger('eshopOrders.invoicesGrid.actions.regenerateDanger');
		}

		$invoice = $this->invoices->get((int) $invoiceId);

		$this->eventDispatcher->dispatch('eshopOrders.afterSaveRegeneratedInvoice', new InvoiceRegenerateEvent($invoice));

		$this->presenter->redrawControl('flashes');
	}

}
