<?php declare(strict_types = 1);

namespace EshopOrders\AdminModule\Model;

use Core\Model\Helpers\BaseEntityService;
use EshopOrders\Model\Entities\Spedition;

/**
 * class Payments
 * @package EshopOrders\Model
 * 
 * @method Spedition|object|null getReference($id)
 * @method Spedition[]|null getAll()
 * @method Spedition|null get($id)
 */
class Speditions extends BaseEntityService
{
	protected $entityClass = Spedition::class;
	
	public function setPosition($id, $position)
	{
		if ($item = $this->get($id)) {
			$item->setPosition($position);
			$this->em->persist($item);
			$this->em->flush();
			
			return true;
		}
		
		return false;
	}
	
	public function setPublish($id, $state)
	{
		if ($item = $this->getReference($id)) {
			$item->isPublished = $state;
			$this->em->persist($item);
			$this->em->flush();
			
			return true;
		}
		
		return false;
	}
}
