<?php declare(strict_types = 1);

namespace EshopOrders\AdminModule\Model;

use Core\Model\Helpers\BaseEntityService;
use EshopOrders\Model\Entities\GroupCustomers;
use Users\Model\Entities\User;
use EshopOrders\Model\Entities\Customer;
use EshopOrders\Model\Entities\Order;

/**
 * class Customers
 * @package EshopOrders\Model
 * 
 * @method Customer|object|null getReference($id)
 * @method Customer[]|null getAll()
 * @method Customer|null get($id)
 */
class Customers extends BaseEntityService
{
	protected $entityClass = Customer::class;
	
	public function isAdmin($id)
	{
		if ($customer = $this->get($id)) {
			$user = $customer->getUser();
			if($user) {
				return ($user->isInRoleByIdent('superadmin') || $user->isInRoleByIdent('admin'));
			} else {
				return false;
			}
		} else {
			return false;
		}
	}
	
	public function setPublish($id, $state)
	{
		if ($customer = $this->get($id)) {
			$user = $customer->getUser();
			
			$user->disable(!$state);
			$this->em->persist($user);
			$this->em->flush();
			
			return true;
		}
		
		return false;
	}

	public function setGroupCustomers($ids, $groupCustomersId)
	{
		try {
			$groupCustomers = $this->em->getReference(GroupCustomers::class, $groupCustomersId);
			foreach ($this->getEr()->findBy(['id' => !is_array($ids) ? [$ids] : $ids]) as $entity) {
				/** @var Customer $entity */
				if ($groupCustomersId != 0)
					$entity->setGroupCustomers($groupCustomers);
				else
					$entity->removeGroupCustomers();
				$this->em->persist($entity);
			}

			$this->em->flush();

			return true;
		} catch (\Exception $e) {
		}

		return false;
	}
}
