<?php declare(strict_types=1);

namespace EshopOrders\FrontModule\Components\Order;

use Nette\Http\Session;
use Nette\Http\SessionSection;
use Core\Model\UI\BaseControl;
use EshopOrders\Model\Orders;
use EshopOrders\Model\Entities\Order;
use EshopOrders\Model\Entities\OrderFlag;
use EshopOrders\FrontModule\Model\TrackingHelper;

class OrderTracking extends BaseControl
{
	
	/** @var Orders */
	protected $ordersService;
	
	/** @var TrackingHelperper */
	protected $trackingHelperService;
	
	/** @var Order */
	public $order;
	
	/** @var SessionSection */
	protected $sessionSection;
	
	/** @var [] */
	protected $zboziCzConfig;
	
	public function __construct($data, Orders $orders, TrackingHelper $trackingHelper, Session $session)
	{
		$this->zboziCzConfig = $data['zboziCzConfig'];
		
		$this->ordersService = $orders;
		
		$this->trackingHelperService = $trackingHelper;
		
		$this->sessionSection = $session->getSection('eshopOrdersOrderForm');
	}
	
	/**
	 * Sledovani objednavky pro Google Tag Manager
	 */
	public function render()
	{
		$this->template->setFile($this->getTemplateFile());
		
		$this->template->order = $this->order;
		$this->template->hasAgreedQuestioning = (int)$this->order->hasFlag(OrderFlag::TYPE_QUESTIONING);
		
		if($this->trackingHelperService->canSend('zboziConversion')) {
			$this->template->canSendZbozi = true;
			$this->template->zboziStoreKey = $this->zboziCzConfig['shopId'];
			$this->template->zboziUseSandbox = $this->zboziCzConfig['isSandbox'];
			
			$this->trackingHelperService->send('zboziConversion');
		}
		
		if($this->trackingHelperService->canSend('gaConversion')) {
			$this->template->canSendGA = true;
			$this->trackingHelperService->send('gaConversion');
		}
		
		$this->template->render();
	}
	
	public function setOrder($ident)
	{
		$this->order = $this->ordersService->getByIdent($ident);
	}
}
