<?php declare(strict_types = 1);

namespace EshopOrders\FrontModule\Model\Dao;

use Gallery\FrontModule\Model\Dao\Image;
use EshopCatalog\FrontModule\Model\Dao\Product;
use EshopCatalog\FrontModule\Model\Dao\ProductVariant;
use Nette\SmartObject;

class CartItem
{
	use SmartObject;

	/** @var int */
	protected $id;

	/** @var int */
	protected $productId;

	/** @var int */
	public $quantity;

	/** @var Product */
	private $product;

	/** @var float */
	protected $price;

	/** @var Image */
	public $image;

	/** @var string */
	protected $link;

	/** @var string */
	public $title;

	/** @var int */
	protected $vatRate;

	/** @var int */
	protected $variantId;

	/** @var ProductVariant */
	protected $productVariant;

	/** @var bool */
	public $freeDelivery = false;

	/** @var bool */
	public $discountDisabled = false;

	/** @var array */
	protected $data = [];

	public function __construct(string $title, int $productId, float $price)
	{
		$this->title     = $title;
		$this->productId = $productId;
		$this->price     = $price;
	}

	public function getId(): int { return $this->id; }

	public function setId(int $id): self
	{
		$this->id = $id;

		return $this;
	}

	public function getProductId(): int { return $this->productId; }

	public function setProductId(int $productId): self
	{
		$this->productId = $productId;

		return $this;
	}

	public function getQuantity(): int { return $this->quantity; }

	public function setQuantity(int $quantity): self
	{
		$this->quantity = $quantity;

		return $this;
	}

	public function getProduct(): ?Product { return $this->product; }

	public function setProduct(Product $product): self
	{
		$this->product = $product;

		return $this;
	}

	public function getVariantId(): ?int { return $this->variantId; }

	public function setVariantId(?int $variantId): self
	{
		$this->variantId = $variantId;

		return $this;
	}

	public function getProductVariant(): ?ProductVariant { return $this->productVariant; }

	public function setProductVariant(?ProductVariant $variant): self
	{
		$this->productVariant = $variant;

		return $this;
	}

	public function getImage(): ?Image { return $this->image; }

	public function setImage(Image $image): self
	{
		$this->image = $image;

		return $this;
	}

	public function getLink(): ?string { return $this->link; }

	public function setLink(string $link): self
	{
		$this->link = $link;

		return $this;
	}

	public function getPrice(): float { return $this->price; }

	public function getPriceWithoutVat(): float { return round($this->getPrice() / (1 + ($this->getVatRate() / 100)), 2); }

	public function setPrice(float $price): self
	{
		$this->price = $price;

		return $this;
	}

	public function getTotalPrice(): float { return $this->getQuantity() * $this->getPrice(); }

	public function getTotalPriceWithoutVat(): float { return round($this->getPriceWithoutVat() * $this->getQuantity(), 2); }

	public function setData(array $arr): self
	{
		$this->data = $arr;

		return $this;
	}

	public function addData(string $key, $value): self
	{
		$this->data[$key] = $value;

		return $this;
	}

	public function getData(?string $key = null)
	{
		if ($key)
			return $this->data[$key] ?? null;

		return $this->data;
	}

	public function getVatRate(): int { return $this->vatRate; }

	public function setVatRate(int $vatRate): self
	{
		$this->vatRate = $vatRate;

		return $this;
	}
}
