<?php declare(strict_types = 1);

namespace EshopOrders\AdminModule\Model\Event;

use Symfony\Component\EventDispatcher\Event;

class OrdersNavigationEvent extends Event
{
	/** @var array */
	protected $navigation;

	public function __construct(array &$navigation)
	{
		$this->navigation = &$navigation;
	}

	public function addNavigation(string $title, $link, ?string $ico = null, ?string $class = null, array $security = [])
	{
		$this->navigation[] = [
			'title'    => $title,
			'link'     => $link,
			'ico'      => $ico,
			'class'    => $class,
			'security' => $security,
		];
	}
}
