<?php declare(strict_types = 1);

namespace EshopOrders\FrontModule\Components\Order;

use Core\Model\Event\ComponentTemplateEvent;
use Core\Model\UI\BaseControl;
use EshopOrders\FrontModule\Model\CartFacade;
use EshopOrders\FrontModule\Model\Speditions;
use EshopOrders\Model\Payments;

class OrderSummary extends BaseControl
{
	/** @var Speditions */
	protected $speditionsService;

	/** @var Payments */
	protected $paymentsService;

	/** @var CartFacade */
	protected $cartFacade;

	/** @var array */
	protected $orderData;

	public function __construct(Speditions $speditions, Payments $payments, CartFacade $cartFacade)
	{
		$this->speditionsService = $speditions;
		$this->paymentsService   = $payments;
		$this->cartFacade       = $cartFacade;
	}

	public function render($discountCoupon = null): void
	{
		$this->template->orderData = $this->getOrderData();
		$this->template->cart      = $this->cartFacade->getCart();

		$this->template->speditions = $this->speditionsService->getAllPublished();
		$this->template->payments   = $this->paymentsService->getAllPublished();

		if ($discountCoupon)
			$this->template->discountCoupon = $discountCoupon;

		$this->eventDispatcher->dispatch('eshopOrders.orderSummary.render', new ComponentTemplateEvent($this->template, $this));

		$this->template->render($this->getTemplateFile());
	}

	public function setParameters($orderData): self
	{
		$this->orderData = $orderData;

		return $this;
	}

	public function getOrderData() { return $this->orderData ?: $this->cartFacade->getOrderFormData(); }
}

