<?php declare(strict_types = 1);

namespace EshopOrders\AdminModule\Components\DashboardWidgets;

use Dashboard\AdminModule\Components\Widget;
use Dashboard\AdminModule\Model\Provider\IWidget;
use EshopOrders\AdminModule\Model\Statistics;

class TodayOrders extends Widget implements IWidget
{
	protected $gridSize = 'col-md-4 col-xxl-3';

	protected $key = 'eshopOrdersTodayOrders';

	/** @var Statistics\Statistics @inject */
	public $statistics;

	public function render()
	{
		$this->template->key   = $this->key;
		$this->template->icon  = 'fas fa-circle';
		$this->template->title = $this->t('eshopOrders.dashboardWidget.todayOrders.title');

		$data                  = $this->statistics->getTodayOrders();
		$this->template->value = $data['count'] . ' / ' . number_format($data['price'], 0, '', ' ') . ' Kč';

		$this->template->baseTemplate = __DIR__ . '/baseCount.latte';
		$this->template->render($this->getTemplateFile());
	}
}
