<?php declare(strict_types = 1);

namespace EshopOrders\AdminModule\Presenters;

use EshopOrders\AdminModule\Components\Customer\IGroupCustomersFormFactory;
use EshopOrders\AdminModule\Components\Customer\IGroupsCustomersGridFactory;
use EshopOrders\Model\Entities\GroupCustomers;
use Nette\Http\IResponse;
use Core\Model\UI\Form\BaseForm;
use EshopOrders\AdminModule\Components\Customer\ICustomerFormFactory;
use EshopOrders\AdminModule\Components\Customer\ICustomersGridFactory;
use EshopOrders\Model\Entities\Customer;

class CustomersPresenter extends BasePresenter
{
	protected function startup()
	{
		parent::startup();
		$this['title']->setTitle($this->translator->translate('eshopOrders.menu.customers'));
		$this->setHeader('eshopOrders.menu.customers', 'fa fa-user-friends');
	}
	
	/*******************************************************************************************************************
	 * ==================  Handle
	 */
	
	/*******************************************************************************************************************
	 * ============================== Actions
	 */

	public function actionDefault()
	{
		$this['navigation']->setData(['header' => [
		
		]]);

		$this['navigation']->setData(['header' => [
			[
				'title' => 'eshopOrders.menu.addGroupCustomers',
				'link'  => 'Customers:addGroup',
				'ico'   => 'plus',
			],
		]]);
	}
	
	public function actionEditCustomer($id)
	{
		$customer = $this->em->getRepository(Customer::class)->find($id);
		
		if (!$customer)
			$this->error(null, IResponse::S404_NOT_FOUND);
		
		$this->setTitle($this->translator->translate('eshopOrders.title.editCustomer'), $customer->getUser()->getName() .' '. $customer->getUser()->getLastname());
		$this->setHeader('eshopOrders.title.editCustomer', 'fa fa-user-friends');
	}

	public function actionAddGroup()
	{
		$this->setTitle($this->translator->translate('eshopOrders.title.addGroupCustomers'));
		$this->setHeader('eshopOrders.title.addGroupCustomers', 'fa fa-users');
	}

	public function actionEditGroup($id)
	{
		$group = $this->em->getRepository(GroupCustomers::class)->find($id);

		if (!$group)
			$this->error(null, IResponse::S404_NOT_FOUND);

		$this->setTitle($this->translator->translate('eshopOrders.title.editGroupCustomers'));
		$this->setHeader('eshopOrders.title.editGroupCustomers', 'fa fa-users');
	}
	
	/*******************************************************************************************************************
	 * ============================== Components
	 */
	
	protected function createComponentCustomersGrid(ICustomersGridFactory $factory)
	{
		return $factory->create();
	}

	protected function createComponentGroupsCustomersGrid(IGroupsCustomersGridFactory $factory)
	{
		return $factory->create();
	}
	
	protected function createComponentCustomerForm(ICustomerFormFactory $factory)
	{
		$control = $factory->create();
		
		if ($this->getParameter('id'))
			$control->setCustomer($this->getParameter('id'));
		
		$control['form']->onSuccessSave[]         = function(BaseForm $form) {
			$this->redirect('editCustomer', $form->getCustomData('customerId'));
		};
		$control['form']->onSuccessSaveAndClose[] = function(BaseForm $form) {
			$this->redirect('default');
		};
		$control['form']->onCancel[]              = function(BaseForm $form) {
			$this->redirect('default');
		};
		
		return $control;
	}

	protected function createComponentGroupCustomersForm(IGroupCustomersFormFactory $factory)
	{
		$control = $factory->create();

		if ($this->getParameter('id'))
			$control->setGroupCustomers($this->getParameter('id'));

		$control['form']->onSuccessSave[]         = function(BaseForm $form) {
			$this->redirect('editGroupCustomers', $form->getCustomData('groupCustomersId'));
		};
		$control['form']->onSuccessSaveAndClose[] = function(BaseForm $form) {
			$this->redirect('default');
		};
		$control['form']->onCancel[]              = function(BaseForm $form) {
			$this->redirect('default');
		};

		return $control;
	}
	
}
