<?php declare(strict_types = 1);

namespace EshopOrders\AdminModule\Components\DashboardWidgets;

use Core\Model\UI\Form\BaseForm;
use Dashboard\AdminModule\Components\Widget;
use Dashboard\AdminModule\Model\Provider\IWidget;
use EshopOrders\AdminModule\Model\Statistics;
use Nette\Utils\ArrayHash;

class MonthlyOrders extends Widget implements IWidget
{
	protected $gridSize = 'col-md-8 col-xxl-6';

	protected $key = 'eshopOrdersMonthlyOrders';

	/** @var \DateTime */
	protected $from, $to;

	/** @var Statistics\Statistics @inject */
	public $statistics;

	public function __construct()
	{
		$this->from = (new \DateTime())->modify('-1 year');
		$this->to   = (new \DateTime());
	}

	public function render()
	{
		$this->template->render($this->getTemplateFile());
	}

	protected function createComponentFromToForm()
	{
		$form = $this->createForm();
		$form->setAjax();

		$form->addDatePicker('from', '')
			->setHtmlAttribute('data-type', 'yearMonth')
			->setHtmlAttribute('onChange', 'window.naja.uiHandler.submitForm(this.form)')
			->setDefaultValue($this->from);
		$form->addDatePicker('to', '')
			->setHtmlAttribute('data-type', 'yearMonth')
			->setHtmlAttribute('onChange', 'window.naja.uiHandler.submitForm(this.form)')
			->setDefaultValue($this->to);

		$form->addSubmit('update', 'default.update');

		$form->onSuccess[] = function(BaseForm $form, ArrayHash $vales) {
			$this->from = $vales->from;
			$this->to = $vales->to;

			$this['grid']->reload();
		};

		return $form;
	}

	protected function createComponentGrid()
	{
		$grid = $this->createGrid();

		$grid->setDataSource($this->statistics->getMonthly($this->from, $this->to));

		$grid->addColumnDateTime('date', 'eshopOrders.dashboardWidget.monthlyOrders.date')->setFormat('Y-m');
		$grid->addColumnNumber('orders', 'eshopOrders.dashboardWidget.monthlyOrders.ordersCount')->setFormat(0, '', ' ');
		$grid->addColumnNumber('ordersPrice', 'eshopOrders.dashboardWidget.monthlyOrders.ordersPrice')->setRenderer(function(array $row) {
			return number_format($row['ordersPrice'], 2, ',', ' ') . ' Kč';
		});

		return $grid;
	}
}
