<?php declare(strict_types = 1);

namespace EshopOrders\AdminModule\Components\Order;

use Core\Model\UI\BaseControl;
use Core\Model\UI\Form\BaseForm;
use EshopOrders\Model\Entities\Order;
use Nette\Utils\ArrayHash;

class IsPaidSwitch extends BaseControl
{
	protected Order $order;

	public function __construct(Order $order)
	{
		$this->order = $order;
	}

	public function render(): void
	{
		$this->template->render($this->getTemplateFile());
	}

	protected function createComponentForm(): BaseForm
	{
		$form = $this->createForm();
		$form->setAjax();

		$form->addBool('isPaid', '')
			->setDefaultValue($this->order->isPaid)
			->setHtmlAttribute('onchange', 'window.naja.uiHandler.submitForm(this.form)');

		$form->onSuccess[] = function(BaseForm $form, ArrayHash $values) {
			$this->order->isPaid = (int) $values->isPaid;
			$this->em->persist($this->order);
			$this->em->flush();

			$this->redrawControl('form');
		};

		return $form;
	}
}
