<?php declare(strict_types = 1);

namespace EshopOrders\AdminModule\Components\Order;

use Core\Model\UI\BaseControl;
use Core\Model\UI\Form\Controls\BoolInput;
use EshopCatalog\FrontModule\Model\Sellers;
use EshopOrders\AdminModule\Model\OrderGifts;
use EshopOrders\FrontModule\Model\CardsPaymentService;
use EshopOrders\Model\Entities\Order;
use EshopOrders\Model\EshopOrdersConfig;
use EshopOrders\Model\Orders;
use EshopOrders\Model\Payments;
use EshopOrders\AdminModule\Model\Speditions;
use Nette\Http\IResponse;
use Core\Model\Templating\Filters\Price as PriceFilter;

class OrderForm extends BaseControl
{
	/** @var Order */
	public $order;

	/** @var Orders */
	protected $ordersService;

	/** @var CardsPaymentService */
	protected $cardPaymentService;

	/** @var Speditions */
	private $speditionsService;

	/** @var Payments */
	private $paymentsService;

	/** @var IOrderItemsGridFactory */
	protected $orderItemsGridFactory;

	/** @var IOrderStatusesGridFactory */
	protected $orderStatusesGridFactory;

	/** @var PriceFilter */
	protected $priceFilter;

	/** @var OrderGifts */
	protected $orderGifts;

	/** @var Sellers */
	protected $sellersService;

	protected IIsPaidSwitchFactory $isPaidSwitchFactory;

	public function __construct(
		Orders $orders,
		Speditions $speditions,
		Payments $payments,
		CardsPaymentService $cardsPaymentService,
		IOrderItemsGridFactory $orderItemsGridFactory,
		IOrderStatusesGridFactory $orderStatusesGridFactory,
		IIsPaidSwitchFactory $isPaidSwitchFactory,
		OrderGifts $orderGifts,
		Sellers $sellers,
		PriceFilter $priceFilter)
	{
		$this->ordersService            = $orders;
		$this->speditionsService        = $speditions;
		$this->paymentsService          = $payments;
		$this->orderItemsGridFactory    = $orderItemsGridFactory;
		$this->orderStatusesGridFactory = $orderStatusesGridFactory;
		$this->cardPaymentService       = $cardsPaymentService;
		$this->isPaidSwitchFactory      = $isPaidSwitchFactory;
		$this->priceFilter              = $priceFilter;
		$this->orderGifts               = $orderGifts;
		$this->sellersService           = $sellers;
	}

	public function render()
	{
		$this->template->order    = $this->order;
		$this->template->seller   = $this->sellersService->getSellerForSite($this->order->site->getIdent());
		$this->template->showPaid = EshopOrdersConfig::load('ordersGrid.showCardHistory') && (
			EshopOrdersConfig::load('showPaidFieldForAllOrders', false) === true
			|| $this->order->getPayment()->getPayment()->getIdent() === 'card');

		if (EshopOrdersConfig::load('ordersGrid.showCardHistory') && $this->order->getPayment()->getPayment()->getIdent() == 'card')
			$this->template->paymentHistory = $this->cardPaymentService->getHistoryOfOrder($this->order->getId());

		$this->template->render($this->getTemplateFile());
	}

	public function setOrder($id)
	{
		$this->order = $this->ordersService->get($id);

		if (!$this->order) {
			$this->getPresenter()->error(null, IResponse::S404_NOT_FOUND);
		}
	}

	public function redrawStatuses(): void
	{
		$this['orderStatusesGrid']['grid']->reload();
	}

	public function handleRemoveGift($id): void
	{
		$presenter = $this->getPresenter();

		if ($this->orderGifts->remove($id)) {
			$presenter->flashMessageSuccess('default.removed');
		} else {
			$presenter->flashMessageDanger('default.removeFailed');
		}

		$this->redrawControl('gifts');
		$presenter->redrawControl('flashes');
	}

	/*******************************************************************************************************************
	 * ============================== Components
	 */

	protected function createComponentOrderItemsGrid()
	{
		$control = $this->orderItemsGridFactory->create($this->order->getId());

		return $control;
	}

	protected function createComponentOrderStatusesGrid()
	{
		$control = $this->orderStatusesGridFactory->create();
		if ($this->order) {
			$control->setOrder($this->order->getId());
		}

		return $control;
	}

	protected function createComponentIsPaidSwitch(): IsPaidSwitch { return $this->isPaidSwitchFactory->create($this->order); }
}
