<?php declare(strict_types = 1);

namespace EshopOrders\AdminModule\Presenters;

use EshopOrders\AdminModule\Components\Expedition\IOrdersGridFactory;
use EshopOrders\AdminModule\Components\Expedition\OrdersGrid;

class ExpeditionPresenter extends BasePresenter
{
	protected function startup()
	{
		parent::startup();
		$this->setHeader('eshopOrders.menu.expedition', 'fas fa-truck-loading');
	}

	/*******************************************************************************************************************
	 * ==================  Handle
	 */

	/*******************************************************************************************************************
	 * ============================== Actions
	 */

	public function actionDefault(): void
	{
		$this['navigation']->setData(['header' => [

		]]);
	}

	/*******************************************************************************************************************
	 * ============================== Components
	 */

	protected function createComponentOrdersForExpedition(IOrdersGridFactory $factory): OrdersGrid
	{
		return $factory->create();
	}
}
