<?php declare(strict_types = 1);

namespace EshopOrders\FrontModule\Model;

use EshopOrders\FrontModule\Model\Dao\Cart;

class CartFacade
{
	/** @var Carts */
	protected Carts $carts;

	/** @var Speditions */
	protected Speditions $speditions;

	/** @var Payments */
	protected Payments $payments;

	/** @var CartHelper */
	protected CartHelper $cartHelper;

	public function __construct(Carts $carts, Speditions $speditions, Payments $payments, CartHelper $cartHelper)
	{
		$this->carts      = $carts;
		$this->speditions = $speditions;
		$this->payments   = $payments;
		$this->cartHelper = $cartHelper;
	}

	public function getCart(): Cart
	{
		$cart = $this->carts->getCurrentCart();

		$formData = $this->getOrderFormData();
		if ($formData['spedition'] && $v = $this->speditions->get($formData['spedition']))
			$cart->setSpedition($v);
		if ($formData['payment'] && $v = $this->payments->get($formData['payment']))
			$cart->setPayment($v);

		return $cart;
	}

	public function getCartsService(): Carts { return $this->carts; }

	public function getOrderFormData(): array { return $this->cartHelper->getOrderFormData(); }

	public function countFreeSpedition(): ?array { return $this->cartHelper->countFreeSpedition(); }
}
