<?php declare(strict_types = 1);

namespace EshopOrders\FrontModule\Model;

use Core\Model\Helpers\BaseService;
use EshopOrders\FrontModule\Model\Dao\Discount;
use EshopOrders\Model\Entities\OrderDiscount;
use EshopSales\FrontModule\Model\OrderSales;
use Nette\DI\Container;
use Nette\Http\Session;
use Nette\Http\SessionSection;
use Nette\SmartObject;
use Users\Model\Security\User;

/**
 * Class CartHelper
 * @package EshopOrders\FrontModule\Model
 */
class CartHelper extends BaseService
{
	use SmartObject;

	const SESSION_KEY = 'eshopOrdersOrderForm';

	/** @var SessionSection */
	protected SessionSection $sessionSection;

	/** @var Carts */
	protected Carts $cartsService;

	/** @var Speditions */
	protected Speditions $speditionsService;

	/** @var Customers */
	protected Customers $customers;

	/** @var Container */
	protected Container $container;

	/** @var User */
	protected User $user;

	/** @var OrderSales|null */
	protected ?OrderSales $orderSales = null;

	public function __construct(Carts $carts, Speditions $speditions, Customers $customers, User $user, Container $container, Session $session)
	{
		$this->cartsService      = $carts;
		$this->speditionsService = $speditions;
		$this->customers         = $customers;
		$this->user              = $user;
		$this->container         = $container;
		$this->sessionSection    = $session->getSection(self::SESSION_KEY);
	}

	// --------------- Doprava zdarma ------------

	public function countFreeSpedition()
	{
		$freeSpeditionPrice = $remainingPrice = null;
		$cart               = $this->cartsService->getCurrentCart();
		$speditionCountry   = $this->getOrderFormData()['speditionCountry'] ?? 'CZ';

		$firstFreeSpedition = $this->speditionsService->getFirstFreeSpedition($speditionCountry);
		if ($firstFreeSpedition) {
			$freeSpeditionPrice = $firstFreeSpedition->getFreeFrom();

			$cart      = $this->cartsService->getCurrentCart();
			$cartPrice = $cart->getCartItemsPrice();

			if ($cartPrice > $freeSpeditionPrice) {
				$remainingPrice = 0;
			} else {
				$remainingPrice = $freeSpeditionPrice - $cartPrice;
			}
		}

		foreach ($cart->getCartItems() as $item) {
			if ($item->freeDelivery === true) {
				$freeSpeditionPrice = $item->getPrice(); //ne 0 -> to by znamenalo ze neni zdarma nikdy
				$remainingPrice     = 0;
				break;
			}
		}

		return ['minPrice' => $freeSpeditionPrice, 'remaining' => $remainingPrice];
	}

	public function getOrderFormData(): array { return $this->sessionSection->orderFormData ?: []; }

	// --------------- Slevove kody ------------

	public function countDiscountPrice()
	{
		$orderSales = $this->orderSales;

		if ($orderSales === null) {
			return 0;
		}

		$cart      = $this->cartsService->getCurrentCart();
		$cartValue = $cart->getCartItemsPrice();
		$price     = 0;

		foreach ($orderSales->getOrderSalesFromCart($cartValue) as $sale) {
			$code = $sale->isAutoSale() ? $sale::AUTO_SALE_ID : $sale->code;

			$discount = new Discount($code, $sale->getAmount(), $sale->getType());
			$price    += $discount->calculateDiscount($cartValue);
		}

		return $price;
	}

	public function setOrderSales(OrderSales $orderSales): void
	{
		$this->orderSales = $orderSales;
	}

}

