<?php declare(strict_types = 1);

namespace EshopOrders\FrontModule\Model\Dao;

use Gallery\FrontModule\Model\Dao\Image;
use EshopCatalog\FrontModule\Model\Dao\Product;

class CartItem
{
	/** @var int */
	public $id;

	/** @var int */
	public $productId;

	/** @var int */
	public $quantity;

	/** @var Product */
	public $product;

	/** @var float */
	protected $price;

	/** @var float */
	public $priceInBaseCurrency;

	/** @var Image */
	public $image;

	/** @var string */
	public $link;

	/** @var string */
	public $title;

	/** @var int */
	protected $vatRate;

	/** @var bool */
	public $freeDelivery = false;

	/** @var bool */
	public $discountDisabled = false;

	/** @var array */
	protected $data = [];

	/** @var CartItemGift[] */
	protected $gifts = [];

	public function __construct(string $title, int $productId, float $price)
	{
		$this->title     = $title;
		$this->productId = $productId;
		$this->price     = $price;
	}

	public function getId(): int { return $this->id; }

	public function setId(int $id): self
	{
		$this->id = $id;

		return $this;
	}

	public function getProductId(): int { return $this->productId; }

	public function setProductId(int $productId): self
	{
		$this->productId = $productId;

		return $this;
	}

	public function getQuantity(): int { return $this->quantity; }

	public function setQuantity(int $quantity): self
	{
		$this->quantity = $quantity;

		return $this;
	}

	public function getProduct(): ?Product { return $this->product; }

	public function setProduct(Product $product): self
	{
		$this->product = $product;

		return $this;
	}

	public function getImage(): ?Image { return $this->image; }

	public function setImage(Image $image): self
	{
		$this->image = $image;

		return $this;
	}

	public function getLink(): ?string { return $this->link; }

	public function setLink(string $link): self
	{
		$this->link = $link;

		return $this;
	}

	public function getPrice(bool $useBaseCurrency = false): float { return $useBaseCurrency ? $this->priceInBaseCurrency : $this->price; }

	public function getPriceWithoutVat(bool $useBaseCurrency = false): float
	{
		return round($this->getPrice($useBaseCurrency) / (1 + ($this->getVatRate() / 100)), 2);
	}

	public function setPrice(float $price): self
	{
		$this->price = $price;

		return $this;
	}

	public function getTotalPrice(bool $useBaseCurrency = false): float { return $this->getQuantity() * $this->getPrice($useBaseCurrency); }

	public function getTotalPriceWithoutVat(bool $useBaseCurrency = false): float
	{
		return round($this->getPriceWithoutVat($useBaseCurrency) * $this->getQuantity(), 2);
	}

	public function setData(array $arr): self
	{
		$this->data = $arr;

		return $this;
	}

	public function addData(string $key, $value): self
	{
		$this->data[$key] = $value;

		return $this;
	}

	public function getData(?string $key = null)
	{
		if ($key)
			return $this->data[$key] ?? null;

		return $this->data;
	}

	public function getVatRate(): int { return $this->vatRate; }

	public function setVatRate(int $vatRate): self
	{
		$this->vatRate = $vatRate;

		return $this;
	}

	/****************
	 * == Gifts
	 */

	/** @return CartItemGift[] */
	public function getGifts(): array { return $this->gifts; }

	public function addGift(CartItemGift $gift): self
	{
		$this->gifts[] = $gift;

		return $this;
	}
}
