<?php declare(strict_types = 1);

namespace EshopOrders\FrontModule\Model\Event;

use Symfony\Contracts\EventDispatcher\Event;

class UpdatedCartItemEvent extends Event
{
	/** @var int */
	public $itemId;

	/** @var int */
	public $quantity;

	public int $beforeQuantity;

	public function __construct(int $itemId, int $quantity, int $beforeQuantity)
	{
		$this->itemId         = $itemId;
		$this->quantity       = $quantity;
		$this->beforeQuantity = $beforeQuantity;
	}
}
