<?php declare(strict_types = 1);

namespace EshopOrders\FrontModule\Model;

use Core\Model\Helpers\BaseFrontEntityService;
use EshopCatalog\FrontModule\Model\ProductsFacade;
use EshopOrders\Model\Entities\Order;

class Orders extends BaseFrontEntityService
{
	/** @var string */
	public $entityClass = Order::class;

	/** @var ProductsFacade */
	protected $productsFacade;

	public function __construct(ProductsFacade $products)
	{
		$this->productsFacade = $products;
	}

	public function getDetail(int $id): ?Order
	{
		return $this->getEr()->createQueryBuilder('o')
			->addSelect('c, pay, sped, disc, del, inv, oStat, stat, items, itemTexts')
			->innerJoin('o.customer', 'c')
			->innerJoin('o.payment', 'pay')
			->innerJoin('o.spedition', 'sped')
			->leftJoin('o.orderDiscounts', 'disc')
			->leftJoin('o.addressInvoice', 'inv')
			->leftJoin('o.addressDelivery', 'del')
			->innerJoin('o.orderStatuses', 'oStat')
			->innerJoin('oStat.status', 'stat')
			->leftJoin('o.orderItems', 'items')
			->leftJoin('items.orderItemTexts', 'itemTexts')
			->where('o.id = :id')->setParameter('id', $id)
			->getQuery()->getOneOrNullResult();
	}
}
