<?php declare(strict_types = 1);

namespace EshopOrders\FrontModule\Presenters;

use EshopCatalog\DI\EshopCatalogExtension;
use EshopOrders\FrontModule\Components\Cart\CartDetail;
use EshopOrders\FrontModule\Components\Order\IOrderFormFactory;
use EshopOrders\FrontModule\Components\Cart\ICartDetailFactory;
use EshopOrders\Model\Orders;
use EshopOrders\FrontModule\Model\Carts;
use EshopCatalog\Model\Config as EshopCatalogConfig;

/**
 * Class DefaultPresenter
 * @package EshopOrders\FrontModule\Presenters
 */
class DefaultPresenter extends BasePresenter
{

	/** @var Orders */
	protected $ordersService;

	/** @var Carts */
	public $cartsService;

	public function __construct(Orders $orders, Carts $carts)
	{
		$this->ordersService = $orders;
		$this->cartsService  = $carts;
	}

	public function cartUpdateListener()
	{
		$this->redrawControl('orderForm');
	}

	/*******************************************************************************************************************
	 * ============================== Actions
	 */

	public function actionOrder(): void
	{
		if (class_exists(EshopCatalogExtension::class)
			&& EshopCatalogConfig::load('allowAddToCartOnlyForLoggedUsers') && !$this->getUser()->isLoggedIn())
			$this->redirectUrl($this->getHomepage()->link);
	}

	/*******************************************************************************************************************
	 * ============================== Render
	 */

	public function renderOrder(): void
	{
		$cart                        = $this->cartsService->getCurrentCart();
		$this->template->pageClass   .= ' page-cart';
		$this->template->cartIsEmpty = empty($cart->getCartItems());
	}

	/*******************************************************************************************************************
	 * ============================== Components
	 */

	protected function createComponentOrderForm(IOrderFormFactory $factory)
	{
		$control = $factory->create();

		return $control;
	}

	protected function createComponentCartDetail(ICartDetailFactory $factory): CartDetail
	{
		$control = $factory->create();

		$this->eventDispatcher->addListener('eshopOrders.cartUpdateItem', [$this, 'cartUpdateListener']);
		$this->eventDispatcher->addListener('eshopOrders.cartRemoveItem', [$this, 'cartUpdateListener']);

		return $control;
	}
}
