<?php declare(strict_types = 1);

namespace EshopOrders\FrontModule\Presenters;

use Core\Model\Event\PresenterTemplateEvent;
use EshopOrders\Model\Entities\Order;
use EshopOrders\Model\Orders;
use EshopOrders\Model\Statuses;

class PaymentPresenter extends BasePresenter
{
	/** @var Orders */
	protected $ordersService;

	/** @var Statuses */
	protected $statusesService;

	public ?Order $order = null;

	protected array $includeTemplates = [];

	public function __construct(Orders $orders, Statuses $statuses)
	{
		$this->ordersService   = $orders;
		$this->statusesService = $statuses;
	}

	/*******************************************************************************************************************
	 * ============================== Actions
	 */
	public function actionPaymentFinished()
	{
		bdump($this->getParameters());
		if ($this->getParameter('orderIdent')) {
			$this->order           = $this->ordersService->getByIdent($this->getParameter('orderIdent'));
			$this->template->order = $this->order;
		}

		if (!$this->order)
			$this->error();

		$this->eventDispatcher->dispatch(new PresenterTemplateEvent($this->template, $this), 'eshopOrders.paymentFinishedRender');
		$this->template->includeTemplates = $this->includeTemplates;
	}

	/*******************************************************************************************************************
	 * ============================== Renders
	 */

	public function renderPaymentFinished()
	{
		//flash zpravy zobrazime v textu, ne jako prekryvne
		$this->template->messages     = $this->getTemplate()->flashes;
		$this->getTemplate()->flashes = [];
	}

	/*******************************************************************************************************************
	 * ============================== Components
	 */

	public function addIncludeTemplate(string $file): self
	{
		$this->includeTemplates[] = $file;

		return $this;
	}
}
