<?php declare(strict_types = 1);

namespace EshopOrders\Model\Entities;

use DateTimeInterface;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\ORM\Mapping as ORM;
use Core\Model\Entities\TId;
use Gedmo\Mapping\Annotation as Gedmo;
use Nette\Utils\DateTime;

/**
 * @ORM\Table("eshop_orders__cart")
 * @ORM\Entity
 */
class Cart
{
	use TId;

	/**
	 * @ORM\Column(name="ident", type="string", nullable=true)
	 */
	public string $ident;

	/**
	 * @var CartItem[]
	 * @ORM\OneToMany(targetEntity="CartItem", mappedBy="cart", indexBy="ident")
	 */
	public $cartItems;

	/**
	 * @var DateTimeInterface
	 * @ORM\Column(name="created", type="datetime", nullable=false, options={"default":"CURRENT_TIMESTAMP"})
	 */
	private $created;

	public function __construct(?string $ident)
	{
		$this->ident     = $ident;
		$this->cartItems = new ArrayCollection();
		$this->created   = new DateTime();
	}

	/******
	 * === Cart Items
	 */

	/**
	 * @return ArrayCollection|CartItem[]
	 */
	public function getCartItems() { return $this->cartItems; }

	public function addCartItem($itemRaw)
	{
		$this->cartItems->add($itemRaw);
	}

	public function removeCartItem($itemId)
	{
		$this->cartItems->remove($itemId);
	}

	public function getCreated(): DateTimeInterface { return $this->created; }
}

