<?php declare(strict_types = 1);

namespace EshopOrders\Model\Entities;

use Doctrine\ORM\Mapping as ORM;
use Core\Model\Entities\TId;
use EshopCatalog\Model\Entities\Product;

/**
 * @ORM\Table("eshop_orders__cart_item")
 * @ORM\Entity
 */
class CartItem
{
	use TId;

	/**
	 * Identifikator slozeny z id produktu, varianty, a pripadne dalsich parametru, ktere maji vliv na cenu
	 * @ORM\Column(name="ident", type="string", nullable=false)
	 */
	protected string $ident;

	/**
	 * @ORM\Column(name="product_id", type="integer", nullable=false)
	 */
	public int $productId;

	/**
	 * @ORM\Column(name="quantity", type="smallint", nullable=false, options={"default":1})
	 */
	public int $quantity;

	/**
	 * @ORM\ManyToOne(targetEntity="Cart", inversedBy="cartItems")
	 * @ORM\JoinColumn(name="cart_id", referencedColumnName="id", onDelete="CASCADE")
	 */
	public Cart $cart;

	public function __construct(string $ident, int $productId, Cart $cart, int $quantity = 1)
	{
		$this->ident     = $ident;
		$this->productId = $productId;
		$this->quantity  = $quantity;
		$this->cart      = $cart;
		$this->cart->addCartItem($this); //Při vytvoření nové položky košíku je potřeba ji přidat rovnou do Entity košíku. Jelikož Proxy Entity ji po vytvoření neobsahuje
	}

	public function getIdent(): string { return $this->getIdent(); }

	public function getProductId(): int { return $this->productId; }
}
