<?php declare(strict_types=1);

namespace EshopOrders\Model\Entities;

use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\ORM\Mapping as ORM;
use Core\Model\Entities\TId;

/**
 * @ORM\Table("eshop_orders__invoice_config")
 * @ORM\Entity
 */
class InvoiceConfig
{
	use TId;

	/**
	 * @var int
	 * @ORM\Column(type="integer", nullable = false)
	 */
	public $maturity;

	/**
	 * @var NumericalSeries
	 * @ORM\OneToOne(targetEntity="NumericalSeries", cascade={"all"})
	 * @ORM\JoinColumn(name="numerical_series_id", referencedColumnName="id", onDelete="CASCADE")
	 */
	public $numericalSeries;

	/**
	 * @var ArrayCollection|SiteInvoiceConfig[]
	 * @ORM\OneToMany(targetEntity="EshopOrders\Model\Entities\SiteInvoiceConfig", mappedBy="invoiceConfig", cascade={"all"})
	 */
	public $siteInvoiceConfigs;

	/**
	 * InvoiceConfig constructor.
	 * @param int $maturity
	 * @param NumericalSeries $numericalSeries
	 */
	public function __construct(int $maturity, NumericalSeries $numericalSeries)
	{
		$this->maturity = $maturity;
		$this->numericalSeries = $numericalSeries;
		$this->siteInvoiceConfigs = new ArrayCollection;
	}

}
