<?php declare(strict_types = 1);

namespace EshopOrders\Model\Entities;

use Core\Model\Event\EventDispatcher;
use Doctrine;
use Doctrine\ORM\Event\LifecycleEventArgs;
use Doctrine\ORM\Mapping as ORM;
use EshopOrders\FrontModule\Model\Event\OrderEvent;
use Symfony\Component\EventDispatcher\EventSubscriberInterface;
use Nette\SmartObject;
use Core\Model\Templating\Filters\Price as PriceFilter;

class OrderListener implements EventSubscriberInterface
{
	use SmartObject;

	/** @var PriceFilter */
	protected $priceFilter;

	/** @var EventDispatcher */
	protected $eventDispatcher;

	public function __construct(PriceFilter $priceFilter, EventDispatcher $eventDispatcher)
	{
		$this->priceFilter     = $priceFilter;
		$this->eventDispatcher = $eventDispatcher;
	}

	public static function getSubscribedEvents(): array
	{
		return [];
	}

	/**
	 * @ORM\PostLoad
	 *
	 * @param Order              $order
	 * @param LifecycleEventArgs $args
	 */
	public function postLoad(Order $order, LifecycleEventArgs $args)
	{
		$order->priceFilter = clone $this->priceFilter;

		$this->eventDispatcher->dispatch(new OrderEvent($order), Order::class . '::postLoad');
	}
}
