<?php declare(strict_types=1);

namespace EshopOrders\Model\Entities;

use Core\Model\Entities\Site;
use Core\Model\Entities\TId;
use Doctrine\ORM\Mapping as ORM;

/**
 * @ORM\Table("eshop_orders__site_invoice_config")
 * @ORM\Entity
 */
class SiteInvoiceConfig
{
	use TId;

	/**
	 * @var InvoiceConfig
	 * @ORM\ManyToOne(targetEntity="InvoiceConfig", inversedBy="siteInvoiceConfigs")
	 * @ORM\JoinColumn(name="site_invoice_config_id", referencedColumnName="id", onDelete="CASCADE")
	 */
	public $invoiceConfig;

	/**
	 * @var Site
	 * @ORM\OneToOne(targetEntity="Core\Model\Entities\Site")
	 * @ORM\JoinColumn(name="site_id", referencedColumnName="ident", onDelete="CASCADE")
	 */
	public $site;

	/**
	 * SiteNumericalSeries constructor.
	 * @param InvoiceConfig $invoiceConfig
	 * @param Site $site
	 */
	public function __construct(InvoiceConfig $invoiceConfig, Site $site)
	{
		$this->invoiceConfig = $invoiceConfig;
		$this->site = $site;
	}

}
