<?php declare(strict_types = 1);

namespace EshopOrders\Model\Event;

use EshopOrders\Model\Entities\Order;
use EshopOrders\Model\Entities\OrderStatus;
use Nette\Application\UI\ITemplate;
use Nette\Mail\Message;
use Symfony\Contracts\EventDispatcher\Event;

class EmailEvent extends Event
{
	public ITemplate $template;

	public Message $message;

	public Order $order;

	public ?OrderStatus $orderStatus = null;

	public function __construct(ITemplate $template, Message $message, Order $order, ?OrderStatus $orderStatus = null)
	{
		$this->template    = &$template;
		$this->message     = &$message;
		$this->order       = $order;
		$this->orderStatus = $orderStatus;
	}
}
