<?php declare(strict_types=1);

namespace EshopOrders\Model\Listeners;

use Doctrine\ORM\Mapping as ORM;
use Doctrine\ORM\Event\LifecycleEventArgs;
use EshopOrders\Model\Entities\Invoice;
use EshopOrders\Model\InvoiceConfigRepository;
use Exception;

class InvoiceListener
{
	/** @var InvoiceConfigRepository */
	protected $invoiceConfigRepository;

	/**
	 * InvoiceListener constructor.
	 * @param InvoiceConfigRepository $invoiceConfigRepository
	 */
	public function __construct(InvoiceConfigRepository $invoiceConfigRepository)
	{
		$this->invoiceConfigRepository = $invoiceConfigRepository;
	}

	/**
	 * @ORM\PrePersist
	 * @param Invoice $invoice
	 * @param LifecycleEventArgs $event
	 * @throws Exception
	 */
	public function prePersist(Invoice $invoice, LifecycleEventArgs $event): void
	{
		$entityManager = $event->getEntityManager();

		$numericalSeries = $this->invoiceConfigRepository->getConfigBySite($invoice->site->getIdent())->numericalSeries;
		$numericalSeries->increaseStartNumber();

		$entityManager->persist($numericalSeries);
	}

}