import {FormatMoney} from 'core/js/utils/formatMoney';

export class AddToCartExtension {
	constructor(naja) {
		this.initCart();

		document.addEventListener('click', e => {
			const target = e.target;

			if (target.matches('.cart-add__submit')) {
				if (target.classList.contains('is-assort')) {
					const wrap = target.closest('.cart-add');

					const modal = '<div class="modal modal--active">\n' +
						'  <div class="modal__header primary-bg-color">\n' +
						'   <span>' + window.cmsTexts.cartAddFormAssortPopupTitle + '</span>\n' +
						'   <div class="modal__close"></div>\n' +
						'  </div>\n' +
						'  <div class="modal__body-wrap">\n' +
						'   <div class="modal__body">\n' +
						'      <div class="cart-add__note-popup-wrap">' +
						'        <label>' + window.cmsTexts.eshopCatalogNote + '</label>' +
						'        <textarea data-target="' + wrap.querySelector('[name="note"]').id + '" class="cart-add__note-popup-placeholder"></textarea>' +
						'      </div>' +
						'      <div class="cart-add__note-popup-buttons">' +
						'        <button class="btn secondary-bg-color" data-popup-assort-cancel>' + window.cmsTexts.cartAddFromAssortPopupCancel + '</button>\n' +
						'        <button class="btn primary-bg-color" data-popup-assort-submit>' + window.cmsTexts.cartAddFormAssortPopupAddToCart + '</button>\n' +
						'      </div>' +
						'     </div>\n' +
						'    </div>\n' +
						'   </div>\n' +
						'  </div>\n' +
						' </div>'
					document.querySelector('.darker').classList.add('darker--active');
					document.body.insertAdjacentHTML('beforeend', modal);
				} else {
					let cartAddForm = target.closest('.cart-add__form');

					if (cartAddForm)
						global.naja.uiHandler.submitForm(cartAddForm);
				}
				e.preventDefault();
			} else if (target.dataset.addToCartQuantityPlus !== undefined) {
				let wrap = target.closest('[data-add-to-cart-quantity-wrap]');
				if (!wrap)
					wrap = target.closest('form');

				let input = wrap.querySelector('[data-add-to-cart-quantity-input]');
				let value = parseInt(input.value);
				let max   = input.dataset.max ? parseInt(input.dataset.max) : 999999;

				if (value < max) {
					input.value = value + 1;
					input.dispatchEvent(new Event('change'));
				}
			} else if (target.dataset.addToCartQuantityMinus !== undefined) {
				let wrap = target.closest('[data-add-to-cart-quantity-wrap]');
				if (!wrap)
					wrap = target.closest('form');

				let input = wrap.querySelector('[data-add-to-cart-quantity-input]');
				let value = parseInt(input.value);
				let min   = input.dataset.allowZero === 'true' ? 0 : 1;

				if (value > min) {
					input.value = value - 1;
					input.dispatchEvent(new Event('change'));
				}
			} else if (target.dataset.popupAssortCancel !== undefined) {
				target.closest('.modal').remove();
				document.querySelector('.darker').classList.remove('darker--active');
			} else if (target.dataset.popupAssortSubmit !== undefined) {
				const modal           = target.closest('.modal');
				const noteInput       = modal.querySelector('.cart-add__note-popup-placeholder');
				const targetNoteInput = document.getElementById(noteInput.dataset.target);

				if (targetNoteInput) {
					targetNoteInput.value = noteInput.value;
					global.naja.uiHandler.submitForm(targetNoteInput.closest('.cart-add__form'));
				}

				modal.remove();
				document.querySelector('.darker').classList.remove('darker--active');
			}
		});

		document.addEventListener('keypress', e => {
			if (e.target.dataset.addToCartQuantityInput !== undefined) {
				if (e.which == 13) {
					e.preventDefault();
					e.stopImmediatePropagation();

					return false;
				}
			}
		});

		global.naja.addEventListener('success', (e) => {
			this.initCart();

			let el = document.activeElement;

			if (el.dataset.inCartText) {
				let originText = el.innerHTML;
				el.innerHTML   = el.dataset.inCartText;
				el.classList.add('added');

				setTimeout(function () {
					el.innerHTML = originText;
					el.classList.remove('added');
				}, 5000);
			}

			const cartItem = e.response.cartItem;
			const currency = e.response.currency;
			if (cartItem) {
				const wrap = document.querySelector('[data-cart-add-product="' + cartItem.productId + '"]');

				if (wrap) {
					const totalWithoutVat = wrap.querySelector('[data-cart-item-total-price-without-vat]');
					if (totalWithoutVat)
						totalWithoutVat.textContent =
							FormatMoney.format(cartItem.totalPriceWithoutVat, currency ? currency.decimal : null);

					const total = wrap.querySelector('[data-cart-item-total-price]');
					if (total)
						total.textContent =
							FormatMoney.format(cartItem.totalPrice, currency ? currency.decimal : null);
				}
			}
		});
	}

	// Odeslání změny quantity inputu v AddToCart a v košíku
	initCart() {
		document.querySelectorAll('[data-add-to-cart-quantity-input="instant"]:not(.init)').forEach((el) => {
			el.classList.add('init');
			el.addEventListener('change', e => {
				let form = e.target.form;
				global.naja.makeRequest('post', form.action, new FormData(form), {
					history: false,
				});
			});
		});
	}
}
