<?php declare(strict_types=1);

namespace EshopOrders\AdminModule\Model\Event;

use Core\Model\UI\AbstractPresenter;
use EshopOrders\Model\Entities\OrderStatus;
use Symfony\Contracts\EventDispatcher\Event;

class OrderStatusEvent extends Event
{
	public OrderStatus $orderStatus;
	public ?AbstractPresenter $presenter;

	/**
	 * OrderStatusEvent constructor.
	 * @param OrderStatus $orderStatus
	 */
	public function __construct(OrderStatus $orderStatus)
	{
		$this->orderStatus = $orderStatus;
	}
}