<?php declare(strict_types = 1);

namespace EshopOrders\FrontModule\Components\Order;

use Core\Model\UI\BaseControl;
use EshopOrders\FrontModule\Model\Carts;
use EshopOrders\FrontModule\Model\Speditions;
use EshopOrders\Model\Payments;
use Nette\Utils\ArrayHash;
use Nette\Application\UI\Multiplier;

class PaySpedSummary extends BaseControl
{
	/** @var Carts */
	private $cartsService;
	
	/** @var Speditions */
	protected $speditionsService;
	
	/** @var Payments */
	protected $paymentsService;
	
	/** @var int */
	private $speditionId;
	
	/** @var int */
	private $paymentId;
	
	/** @var int */
	private $priceTotal;
	
	public function __construct(Carts $carts, Speditions $speditions, Payments $payments)
	{
		$this->cartsService      = $carts;
		$this->speditionsService = $speditions;
		$this->paymentsService   = $payments;
	}
	
	/**
	 * zobrazeni kosiku na kazdem kroku objednavky
	 */
	public function render()
	{
		$this->template->setFile($this->getTemplateFile());
		
		$this->template->paySpedCombination = $this->getSpeditionPaymentCombination($this->speditionId, $this->paymentId);
		$this->template->priceTotal = $this->priceTotal;
		
		$this->template->render();
	}
	
	public function getSpeditionPaymentCombination($speditionId, $paymentId)
	{
		$spedition = $payment = null;
		if($speditionId) {
			$spedition = $this->speditionsService->get($speditionId);
		}
		if($paymentId) {
			$payment = $this->paymentsService->get($paymentId);
		}
		$cart = $this->cartsService->getCurrentCart();
		$cartPrice = $cart->getPriceTotal();
		
		$text = '';
		$price = 0;
		
		if($spedition) {
			$text .= $spedition->getName();
			$price += $spedition->getPriceActual($cart);
			if($payment) {
				$text .= ', ';
			}
		}
		if($payment) {
			$text .= $payment->getName();
			$price += $payment->getPrice();
		}
		$combination = ['text' => $text, 'price' => $price];
		
		return $combination;
	}
	
	public function setParameters($speditionId, $paymentId, $priceTotal)
	{
		$this->speditionId = $speditionId;
		$this->paymentId   = $paymentId;
		$this->priceTotal  = $priceTotal;
	}
}

