<?php declare(strict_types = 1);

namespace EshopOrders\FrontModule\Model\Subscribers;

use Core\Model\Event\ControlEvent;
use Core\Model\UI\FrontPresenter;
use EshopOrders\FrontModule\Model\Customers;
use Symfony\Component\EventDispatcher\EventSubscriberInterface;
use Currency\Model\Currencies;

class PresenterSubscriber implements EventSubscriberInterface
{
	protected Currencies $currenciesService;

	protected Customers $customers;

	public function __construct(Currencies $currencies, Customers $customers)
	{
		$this->currenciesService = $currencies;
		$this->customers         = $customers;
	}

	public static function getSubscribedEvents(): array
	{
		return [
			FrontPresenter::class . '::startup' => 'startup',
		];
	}

	public function startup(ControlEvent $event): void
	{
	}
}
