<?php declare(strict_types = 1);

namespace EshopOrders\Model\Entities;

use Doctrine\ORM\Mapping as ORM;

/**
 * @ORM\Table("eshop_orders__group_param")
 * @ORM\Entity
 */
class GroupParam
{
	/**
	 * @ORM\Id
	 * @ORM\ManyToOne(targetEntity="GroupCustomers")
	 * @ORM\JoinColumn(name="group_id", referencedColumnName="id", onDelete="CASCADE")
	 */
	public GroupCustomers $group;

	/**
	 * @ORM\Id
	 * @ORM\Column(name="`key`", type="string", length=255, nullable=false)
	 */
	public string $key;

	/**
	 * @ORM\Column(name="`value`", type="text", nullable=true)
	 */
	public ?string $value = null;

	public function __construct(GroupCustomers $group, string $key)
	{
		$this->group = $group;
		$this->key   = $key;
		$group->getParams()->set($key, $this);
	}
}
