<?php declare(strict_types = 1);

namespace EshopOrders\Model\Helpers;

use Core\Model\UI\BaseControl;
use EshopOrders\Model\EshopOrdersConfig;
use Nette\Caching\Cache;
use Nette\Caching\Storage;
use Nette\Utils\Json;

class Psc
{
	public const CACHE_NAMESPACE = 'EshopOrdersPsc';

	protected Storage $storage;

	protected Cache $cache;

	protected ?array $cPsc = null;

	public function __construct(Storage $storage)
	{
		$this->cache = new Cache($storage, self::CACHE_NAMESPACE);
	}

	public function getPsc(): array
	{
		if (!EshopOrdersConfig::load('orderForm.validatePsc'))
			return [];

		if ($this->cPsc === null) {
			$this->cPsc = [];

			$this->cPsc = $this->cache->load('psc', function(&$dep): array {
				$dep = [Cache::EXPIRATION => '1 hour'];
				$arr = [];

				try {
					$ch = curl_init();
					curl_setopt($ch, CURLOPT_URL, EshopOrdersConfig::load('api.pscUrl'));
					curl_setopt($ch, CURLOPT_HEADER, false);
					curl_setopt($ch, CURLOPT_HTTPHEADER, ["Content-Type: application/json", "Accept:application/json"]);
					curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
					curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);
					curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
					$result = curl_exec($ch);
					curl_close($ch);

					if ($result) {
						$result = Json::decode($result, Json::FORCE_ARRAY);

						foreach ($result['data'] ?? [] as $row) {
							$arr[(int) $row['psc']] = (int) $row['psc'];
						}
					}
				} catch (\Exception $e) {
				}

				return $arr;
			});
		}

		return $this->cPsc;
	}

	public function validatePsc(int $psc): bool { return isset($this->getPsc()[$psc]); }
}
