<?php declare(strict_types = 1);

namespace EshopOrders\AdminModule\Components\Order;

use Core\Model\UI\BaseControl;
use Core\Model\UI\Form\BaseForm;
use EshopOrders\Model\Entities\Order;
use EshopOrders\Model\Entities\OrderAddress;
use EshopOrders\Model\Orders;
use EshopOrders\Model\Payments;
use EshopOrders\AdminModule\Model\Speditions;
use Nette\Http\IResponse;
use Nette\Utils\ArrayHash;

class OrderForm extends BaseControl
{
	/** @var Order */
	public $order;
	
	/** @var Orders */
	protected $ordersService;
	
	/** @var Speditions */
	private $speditionsService;
	
	/** @var Payments */
	private $paymentsService;
	
	/** @var IOrderItemsGridFactory */
	protected $orderItemsGridFactory;
	
	/** @var IOrderStatusesGridFactory */
	protected $orderStatusesGridFactory;
	
	public function __construct(
		Orders $orders,
		Speditions $speditions,
		Payments $payments,
		IOrderItemsGridFactory $orderItemsGridFactory,
		IOrderStatusesGridFactory $orderStatusesGridFactory)
	{
		$this->ordersService = $orders;
		$this->speditionsService = $speditions;
		$this->paymentsService = $payments;
		$this->orderItemsGridFactory = $orderItemsGridFactory;
		$this->orderStatusesGridFactory = $orderStatusesGridFactory;
	}
	
	public function render()
	{
		$this->template->order = $this->order;
		$this->template->render($this->getTemplateFile());
	}
	
	public function setOrder($id)
	{
		$this->order = $this->ordersService->get($id);
		
		if (!$this->order) {
			$this->getPresenter()->error(null, IResponse::S404_NOT_FOUND);
		}
	}
	
	/*******************************************************************************************************************
	 * ============================== Components
	 */
	
	protected function createComponentOrderItemsGrid()
	{
		$control = $this->orderItemsGridFactory->create();
		if ($this->order) {
			$control->setOrder($this->order->getId());
		}
		return $control;
	}
	
	protected function createComponentOrderStatusesGrid()
	{
		$control = $this->orderStatusesGridFactory->create();
		if ($this->order) {
			$control->setOrder($this->order->getId());
		}
		return $control;
	}
}
