<?php declare(strict_types = 1);

namespace EshopOrders\AdminModule\Components\Payment;

use Core\Model\UI\BaseControl;
use Core\Model\UI\Form\BaseForm;
use Nette\Application\UI\Form;
use Nette\Http\IResponse;
use Nette\Utils\ArrayHash;
use EshopOrders\Model\Entities\Payment;
use EshopOrders\Model\Payments;

class PaymentForm extends BaseControl
{
	/** @var Payment */
	public $payment;

	/** @var Payments */
	protected $paymentsService;

	public function __construct(Payments $payments)
	{
		$this->paymentsService = $payments;
	}

	public function render()
	{
		$this->template->render($this->getTemplateFile());
	}

	protected function createComponentForm()
	{
		$form = $this->createForm();

		$form->addText('name', 'default.name')->setRequired()->setMaxLength(255);
		$form->addText('ident', 'eshopOrders.paymentForm.itemIdent')->setMaxLength(255);
		$form->addText('text', 'default.text')->setMaxLength(255);
		$form->addBool('isPublished', 'default.isActive')->setDefaultValue(1);
		$form->addInteger('price', 'eshopOrders.default.priceSimple');
		$form->addInteger('availableFrom', 'eshopOrders.default.availableFrom');
		$form->addInteger('availableTo', 'eshopOrders.default.availableTo');
		$form->addFilesManager('image', 'default.image');
		$form->addSaveCancelControl('saveControl');
		
		$form->onSuccess[] = [$this, 'formSuccess'];

		return $form;
	}

	public function formSuccess(BaseForm $form, ArrayHash $values)
	{
		try {
			if ($this->payment) {
				$payment       = $this->payment;
				$flashMessage = 'eshopOrders.paymentForm.edited';
			} else {
				$payment       = new Payment();
				$flashMessage = 'eshopOrders.paymentForm.added';
			}
			
			$payment->setName($values->name);
			$payment->setIdent($values->ident);
			$payment->setText($values->text);
			$payment->isPublished = $values->isPublished;
			$payment->setPrice($values->price);
			$payment->setAvailableFrom($values->availableFrom);
			$payment->setAvailableTo($values->availableTo);
			$payment->image = $values->image;

			$this->em->persist($payment)->flush();
			$form->addCustomData('paymentId', $payment->getId());
			$this->getPresenter()->flashMessageSuccess($flashMessage);
		} catch (\Exception $e) {
			$form->addError($e->getMessage());

			return false;
		}
	}

	public function setPayment($id)
	{
		$this->payment = $this->paymentsService->get($id);

		if ($this->payment) {
			$o = $this->payment;
			$this['form']->setDefaults([
				'name'        => $o->getName(),
				'ident'       => $o->getIdent(),
				'text'        => $o->getText(),
				'isPublished' => $o->isPublished,
				'price'       => $o->getPrice(),
				'availableFrom' => $o->getAvailableFrom(),
				'availableTo' => $o->getAvailableTo(),
				'image'       => $o->image,
			]);
		} else
			$this->getPresenter()->error(null, IResponse::S404_NOT_FOUND);
	}
}
