<?php declare(strict_types = 1);

namespace EshopOrders\AdminModule\Components\PaymentSpedition;

use Core\Model\UI\BaseControl;
use EshopOrders\Model\Payments;
use EshopOrders\AdminModule\Model\Speditions;
use EshopOrders\Model\PaymentSpeditions;

class PaymentSpeditionsGrid extends BaseControl
{
	/** @var PaymentSpeditions */
	protected $paymentSpeditionsService;
	
	/** var Payments */
	protected $paymentsService;
	
	/** @var Speditions */
	protected $speditionsService;
	
	public function __construct(PaymentSpeditions $paymentSpeditions, Payments $payments, Speditions $speditions)
	{
		$this->paymentSpeditionsService = $paymentSpeditions;
		$this->paymentsService          = $payments;
		$this->speditionsService        = $speditions;
	}
	
	public function render()
	{
		$this->template->render($this->getTemplateFile());
	}
	
	protected function createComponentGrid()
	{
		$grid = $this->createGrid();
		
		$qb = $this->paymentSpeditionsService->getEr()->createQueryBuilder('ps')
			->leftJoin('ps.payment', 'p')
			->leftJoin('ps.spedition', 's')
			->addOrderBy('s.position', 'ASC')
			->addOrderBy('p.position', 'ASC');
		$grid->setDataSource($qb);
		
		//Columns
		$grid->addColumnLink('spedition', 'eshopOrders.default.spedition', 'PaymentSpedition:editPaymentSpedition', 'spedition.name');
		$grid->addColumnLink('payment', 'eshopOrders.default.payment', 'PaymentSpedition:editPaymentSpedition', 'payment.name');
		$grid->addColumnStatus('isPublished', 'default.isActive')->setAlign('center')
			->addOption(1, 'eshopOrders.defaultGrid.publish')->setIcon('check')->setClass('btn-success')->setShowTitle(false)->endOption()
			->addOption(0, 'eshopOrders.defaultGrid.unPublish')->setIcon('times')->setClass('btn-danger')->setShowTitle(false)->endOption()
			->onChange[] = [$this, 'gridPublishChange'];
		
		// Filter
		
		// Actions
		$grid->addAction('edit', '', 'PaymentSpedition:editPaymentSpedition')->setIcon('edit')->setBsType('primary');
		$grid->addAction('delete', '', 'delete!')->setConfirm('default.reallyDelete')->setIcon('times')->setBsType('danger')->addClass('ajax');
		
		// Columns prototype
		
		return $grid;
	}
	
	
	/*******************************************************************************************************************
	 * ==================  Handle
	 */
	
	public function handleDelete($id)
	{
		$presenter = $this->getPresenter();
		if ($this->paymentsService->remove($id))
			$presenter->flashMessageSuccess('default.removed');
		else
			$presenter->flashMessageDanger('default.removeFailed');
		
		if ($presenter->isAjax()) {
			$this['grid']->reload();
			$presenter->redrawControl('flashes');
		} else
			$presenter->redirect('this');
	}
	
	
	/*******************************************************************************************************************
	 * =================  Grid function
	 */
	
	public function gridPublishChange($id, $newStatus)
	{
		$presenter = $this->getPresenter();
		
		if ($this->paymentSpeditionsService->setPublish($id, $newStatus))
			$presenter->flashMessageSuccess('eshopOrders.defaultGrid.publishChanged');
		else
			$presenter->flashMessageDanger('eshopOrders.defaultGrid.publishChangeFailed');
		
		if ($presenter->isAjax()) {
			$this['grid']->redrawItem($id);
			$presenter->redrawControl('flashes');
		} else
			$presenter->redirect('this');
	}
	
}
