<?php declare(strict_types = 1);

namespace EshopOrders\FrontModule\Components\Cart;

use Core\Model\UI\BaseControl;
use EshopOrders\FrontModule\Model\Carts;
use EshopOrders\FrontModule\Model\Dao\CartItem;
use Nette\Utils\ArrayHash;
use Nette\Application\UI\Multiplier;

class CartDetailItem extends BaseControl
{
	/** @var Carts */
	private $cartsService;

	public function __construct(Carts $carts)
	{
		$this->cartsService     = $carts;
	}
	
	//zobrazeni polozek v kosiku na strance s objednavkou
	public function render($item)
	{
		$this->template->setFile($this->getTemplateFile());
		
		$this->template->item = $item;
		
		$this->template->render();
	}

	protected function createComponentForm()
	{
		return new Multiplier(function($itemId) {
			$item = $this->getItem($itemId);
			
			$form = $this->createForm();
			//$form->setAjax();

			$form->addText('quantity', null)
				->addRule($form::FILLED)
				->addRule($form::INTEGER)
				->setHtmlAttribute('class', ['quantityInput', 'input-style'])
				->setDefaultValue($item->quantity);
			$form->addHidden('itemId', $item->id); //TODO melo by to byt ID polozky, ne produktu

			$form->onSuccess[] = [$this, 'formOnSuccess'];

			return $form;
		});
	}

	private function getItem($itemId)
	{
		return $this->cartsService->getCartItem($itemId);
	}

	public function formOnSuccess($form, ArrayHash $values)
	{
		try {
			$itemId = $values->itemId;
			$quantity = $values->quantity;
			$this->cartsService->updateItemQuantity($itemId, $quantity);
			$this->getPresenter()->flashMessageSuccess('eshopOrders.cart.countUpdated');
			
			$this->getPresenter()->redrawControl('orderCartDetail');
			$this->getPresenter()->redrawControl('cartPreview');
			$this->getPresenter()->redrawControl('cartPreviewMobile');
			$this->getPresenter()->redrawControl('flashes');
			//$this->getPresenter()->redrawControl('orderForm'); TODO
		} catch (\Exception $e) {
			$this->getPresenter()->flashMessageWarning('eshopOrders.cart.countUpdateErr');
			$this->getPresenter()->redrawControl('flashes');
			return false;
		}
		
	}
}

