<?php declare(strict_types = 1);

namespace EshopOrders\FrontModule\Components\Order;

use Core\Model\UI\BaseControl;
use EshopOrders\FrontModule\Model\Carts;
use EshopOrders\FrontModule\Model\Dao\CartItem;
use Nette\Utils\ArrayHash;
use Nette\Application\UI\Multiplier;

class OrderCartDetail extends BaseControl
{
	/** @var Carts */
	private $cartsService;
	
	/** @var Cart */
	private $cart;

	public function __construct(Carts $carts)
	{
		$this->cartsService     = $carts;
	}
	
	/**
	 * zobrazeni kosiku na kazdem kroku objednavky
	 * @param array|null $discountCoupon
	 */
	public function render($discountCoupon = null)
	{
		$this->template->setFile($this->getTemplateFile());
		
		$cart = $this->getCart();
		$this->template->cartItems = $cart->cartItems;
		$this->template->cartItemsPrice = $cart->getPriceTotal();
		
		if($discountCoupon) $this->template->discountCoupon = $discountCoupon;
		
		$this->template->render();
	}
	
	//zobrazeni polozek v kosiku na strance s objednavkou
	public function renderSummary()
	{
		$this->template->setFile($this->getTemplateFile('CartDetailSummary', 'Order'));
		
		$cart = $this->getCart();
		$this->template->cartItems = $cart->cartItems;
		$this->template->cartItemsPrice = $cart->getPriceTotal();
		
		$this->template->render();
	}
	
	protected function getCart()
	{
		if(!$this->cart) {
			$this->cart = $this->cartsService->getCurrentCart();
		}
		
		return $this->cart;
	}
}

