<?php declare(strict_types=1);

namespace EshopOrders\FrontModule\Components\Order;

use Core\Model\UI\BaseControl;
use Nette\Utils\ArrayHash;
use Nette\Application\UI\Multiplier;
use Nette\Http\Session;
use Nette\Http\SessionSection;
use EshopOrders\FrontModule\Model\Carts;
use EshopOrders\FrontModule\Model\Speditions;
use EshopOrders\Model\Payments;

class OrderSummary extends BaseControl
{
	/** @var Speditions */
	protected $speditionsService;
	
	/** @var Payments */
	protected $paymentsService;
	
	/** @var Carts */
	protected $cartsService;
	
	/** @var SessionSection */
	protected $sessionSection;
	
	/** @var array */
	private $orderData;
	
	public function __construct(Speditions $speditions, Payments $payments, Carts $carts, Session $session)
	{
		$this->speditionsService = $speditions;
		$this->paymentsService   = $payments;
		$this->cartsService      = $carts;
		
		$this->sessionSection = $session->getSection('eshopOrdersOrderForm');
	}
	
	/**
	 * zobrazeni souhrnu objednavky na poslednim kroku
	 * @param array|null $discountCoupon
	 */
	public function render($discountCoupon = null)
	{
		$this->template->setFile($this->getTemplateFile());
		
		//priceTotal je soucasti dat v session... Je to tak spravne?
		$this->template->orderData = $this->orderData;
		$this->template->cart      = $this->cartsService->getCurrentCart();
		
		$this->template->speditions = $this->speditionsService->getAllPublished();
		$this->template->payments   = $this->paymentsService->getAllPublished();
		
		if($discountCoupon) $this->template->discountCoupon = $discountCoupon;
		
		$this->template->render();
	}
	
	public function setParameters($orderData)
	{
		$this->orderData = $orderData;
	}
}

