<?php declare(strict_types = 1);

namespace EshopOrders\FrontModule\Model\Dao;

use Kdyby\Doctrine\Entities\MagicAccessors;

class Cart
{
	use MagicAccessors;
	
	/** @var int */
	public $id;
	
	/** @var string */
	public $ident;

	/** @var CartItem[] */
	public $cartItems;
	
	public function setId(int $id)
	{
		$this->id = $id;
		return $this;
	}
	
	public function setIdent($ident)
	{
		$this->ident = $ident;
		return $this;
	}

	public function setCartItems($cartItems)
	{
		$this->cartItems = $cartItems;
		return $this;
	}
	
	public function getId(): int
	{
		return $this->id;
	}

	public function getIdent()
	{
		return $this->ident;
	}
	
	/** @return CartItem[] */
	public function getCartItems(): array
	{
		return $this->cartItems;
	}
	
	public function getPriceTotal()
	{
		$priceTotal = 0;
		foreach ($this->cartItems as $item) {
			$priceTotal += $item->getProduct()->getPrice() * $item->getQuantity();
		}
		return $priceTotal;
	}
	
	public function getItemsCount()
	{
		$count = 0;
		foreach ($this->cartItems as $item) {
			$count += $item->getQuantity();
		}
		return $count;
	}
}


