<?php declare(strict_types = 1);

namespace EshopOrders\FrontModule\Model\Dao;

use Kdyby\Doctrine\Entities\MagicAccessors;
use EshopCatalog\FrontModule\Model\Dao\Product;
use EshopCatalog\FrontModule\Model\Dao\ProductVariant;

class CartItem
{
	use MagicAccessors;

	/** @var int */
	public $id;
	
	/** @var int */
	public $productId;

	/** @var Product */
	private $product;
	
	/** @var int */
	public $variantId;
	
	/** @var ProductVariant */
	private $productVariant;

	/** @var int */
	public $quantity;

	public function setId($id)
	{
		$this->id = $id;

		return $this;
	}

	public function setCartId($cartId)
	{
		$this->cartId = $cartId;

		return $this;
	}

	public function setProductId($productId)
	{
		$this->productId = $productId;

		return $this;
	}

	public function setQuantity($quantity)
	{
		$this->quantity = $quantity;

		return $this;
	}

	/**
	 * @param Product $product
	 *
	 * @return CartItem
	 */
	public function setProduct(Product $product): CartItem
	{
		$this->product = $product;

		return $this;
	}

	/**
	 * @return int
	 */
	public function getId(): int
	{
		return $this->id;
	}

	/**
	 * @return int
	 */
	public function getCartId(): int
	{
		return $this->cartId;
	}

	/**
	 * @return int
	 */
	public function getProductId(): int
	{
		return $this->productId;
	}

	/**
	 * @return Product
	 */
	public function getProduct(): Product
	{
		return $this->product;
	}

	/**
	 * @return int
	 */
	public function getQuantity(): int
	{
		return intval($this->quantity);
	}
	
	/*******
	 * === Variant
	 */
	
	public function setVariantId($variantId): CartItem
	{
		$this->variantId = $variantId;
		return $this;
	}
	
	public function getVariantId()
	{
		return $this->variantId;
	}
	
	public function setProductVariant($variant)
	{
		$this->productVariant = $variant;
		return $this;
	}
	
	public function getProductVariant()
	{
		return $this->productVariant;
	}
	
}



