<?php declare(strict_types=1);

namespace EshopOrders\FrontModule\Model\Listeners;

use EshopOrders\FrontModule\Model\Carts;
use EshopOrders\FrontModule\Model\Dao\AddedCartItem;
use Kdyby\Events\Subscriber;
use Nette\SmartObject;

class CartListener implements Subscriber
{
	use SmartObject;
	
	/** @var Carts */
	private $cartsService;
	
	public function __construct(Carts $carts)
	{
		$this->cartsService     = $carts;
	}
	
	/** Napojeni na udalost - pridani do kosiku
	 * @return array|string[]
	 */
	public function getSubscribedEvents()
	{
		return [
			'EshopOrders\FrontModule\Model\Carts::onAddItem'
		];
	}
	
	public function onAddItem(AddedCartItem $item)
	{
		$this->cartsService->addItem($item);
	}
}
