<?php declare(strict_types = 1);

namespace EshopOrders\Model\Entities;

use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\ORM\Mapping as ORM;
use Kdyby\Doctrine\Entities\Attributes\Identifier;
use Kdyby\Doctrine\Entities\MagicAccessors;

/**
 * @ORM\Table("eshop_orders__cart")
 * @ORM\Entity
 */
class Cart
{
	use Identifier;
	use MagicAccessors;

	/**
	 * @var string
	 * @ORM\Column(name="ident", type="string", nullable = true)
	 */
	public $ident;

	/**
	 * @var CartItem[]
	 * @ORM\OneToMany(targetEntity="CartItem", mappedBy="cart", indexBy="ident")
	 */
	public $cartItems;

	public function __construct($ident)
	{
		$this->ident      = $ident;
		$this->cartItems  = new ArrayCollection();
	}

	/******
	 * === Cart Items
	 */

	/**
	 * @return ArrayCollection|CartItem[]
	 */
	public function getCartItems() { return $this->cartItems ?: []; }

	public function addCartItem($itemRaw)
	{
		$this->cartItems->add($itemRaw);
	}

	public function removeCartItem($itemId)
	{
		$this->cartItems->remove($itemId);
	}

}

