<?php declare(strict_types = 1);

namespace EshopOrders\Model\Entities;

use Doctrine\ORM\Mapping as ORM;
use Kdyby\Doctrine\Entities\Attributes\Identifier;
use Kdyby\Doctrine\Entities\MagicAccessors;

/**
 * @ORM\Table("eshop_orders__customer_address")
 * @ORM\Entity
 */
class CustomerAddress
{
	use Identifier;
	use MagicAccessors;
	
	/**
	 * @var string
	 * @ORM\Column(name="email", type="string", length=255, nullable = true)
	 */
	protected $email;
	
	/**
	 * @var string
	 * @ORM\Column(name="phone", type="string", length=255, nullable = true)
	 */
	protected $phone;
	
	/**
	 * @var string
	 * @ORM\Column(name="company", type="string", nullable = true)
	 */
	protected $company;
	
	/**
	 * @var string
	 * @ORM\Column(name="street", type="string", nullable = true)
	 */
	protected $street;
	
	/**
	 * @var string
	 * @ORM\Column(name="city", type="string", nullable = true)
	 */
	protected $city;
	
	/**
	 * @var string
	 * @ORM\Column(name="postal", type="string", nullable = true)
	 */
	protected $postal;
	
	/** IČO
	 * @var string
	 * @ORM\Column(name="id_number", type="string", nullable = true)
	 */
	protected $idNumber;
	
	/** DIČ
	 * @var string
	 * @ORM\Column(name="vat_number", type="string", nullable = true)
	 */
	protected $vatNumber;
	
	/**
	 * @var Customer
	 * @ORM\ManyToOne(targetEntity="Customer", inversedBy="addressesAvailable")
	 * @ORM\JoinColumn(name="customer_id", referencedColumnName="id", onDelete="CASCADE")
	 */
	protected $customer;
	
	/**
	 * CustomerAddress constructor.
	 * @param $customer
	 */
	public function __construct($customer)
	{
		$this->customer = $customer;
	}
	
	/*******
	 * === Customer
	 */
	
	public function getCustomer()
	{
		return $this->customer;
	}
	
	/*******
	 * === FirstName
	 */
	
	public function getFirstName()
	{
		return $this->firstName;
	}
	
	public function setFirstName($firstName)
	{
		$this->firstName = $firstName;
		return $this;
	}
	
	/*******
	 * === LastName
	 */
	
	public function getLastName()
	{
		return $this->lastName;
	}
	
	public function setLastName($lastName)
	{
		$this->lastName = $lastName;
		return $this;
	}
	
	/*******
	 * === Company
	 */
	
	public function getCompany()
	{
		return $this->company;
	}
	
	public function setCompany($company)
	{
		$this->company = $company;
		return $this;
	}
	
	/*******
	 * === Street
	 */
	
	public function getStreet()
	{
		return $this->street;
	}
	
	public function setStreet($street)
	{
		$this->street = $street;
		return $this;
	}
	
	/*******
	 * === City
	 */
	
	public function getCity()
	{
		return $this->city;
	}
	
	public function setCity($city)
	{
		$this->city = $city;
		return $this;
	}
	
	/*******
	 * === Postal
	 */
	
	public function getPostal()
	{
		return $this->postal;
	}
	
	public function setPostal($postal)
	{
		$this->postal = $postal;
		return $this;
	}
	
	/*******
	 * === IdNumber - ICO
	 */
	
	public function getIdNumber()
	{
		return $this->idNumber;
	}
	
	public function setIdNumber($idNumber): OrderAddress
	{
		$this->idNumber = $idNumber;
		return $this;
	}
	
	/*******
	 * === VatNumber - DIC
	 */
	
	public function getVatNumber()
	{
		return $this->vatNumber;
	}
	
	public function setVatNumber($vatNumber): OrderAddress
	{
		$this->vatNumber = $vatNumber;
		return $this;
	}
}
